<?php
require_once( "Constants.class.php" ) ;
require_once( "CommonUtility.class.php" ) ;
require_once( "ConfManager.class.php" ) ;
require_once( "DbManager.class.php" ) ;
require_once( "ScManager.class.php" ) ;
require_once( "MsManager.class.php" ) ;
require_once( "EsxiManager.class.php" ) ;
require_once( "UsbxErrorCodeManager.class.php" ) ;

$DTASCFG_XML_FILE = "/etc/dtascfg.xml";
$BACKEND = "php " . dirname(__FILE__) . "/../backend.php";
$SHM_ERROR_REPORT_ID = "6668";

# multiple images tmp files
$BASE = "/opt/TrendMicro/Pixiebob/textUI/";
$ORIGIN_SB_GROUP_INFO_ESXI_FILE = $BASE . "OriSBGroupInfoESXi";
$ORIGIN_SB_GROUP_INFO_VIX_FILE = $BASE . "OriSBGroupInfoVIX";
$NEW_SB_GROUP_INFO_ESXI_FILE = $BASE . "NewSBGroupInfoESXi";
$NEW_SB_GROUP_INFO_VIX_FILE = $BASE . "NewSBGroupInfoVIX";
$NEW_SB_GROUP_TO_BE_REMOVED_FILE = $BASE . "NewSBGroupToBeRemoved";
$NEW_SB_GROUP_TO_BE_KEPT_FILE = $BASE . "NewSBGroupToBeKept";
$NEW_SB_GROUP_TO_BE_ADDED_FILE = $BASE . "NewSBGroupToBeAdded";
$NEW_SB_ADDED_FILE = $BASE . "NewSBAdded";
$CLUSTER_DTASCFG_XML_FILE = $BASE . "cluster_dtascfg.xml";

function stop_vm_and_wait($esxi_ip, $esxi_username, $esxi_password, $vmpath) {
	global $BACKEND;

    // Escape variables since then they will be used in command line
    $esxi_username = escapeshellarg($esxi_username);
    $esxi_password = escapeshellarg($esxi_password);

	unset($result_array);
	$result_we_wanted = exec("$BACKEND get_esxi_vm_state $esxi_ip $esxi_username $esxi_password $vmpath 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);
	if(strcmp(trim($result_we_wanted), 'getstate() = on') == 0) {
		$result_array = array();
		exec("$BACKEND switch_esxi_vm $esxi_ip $esxi_username $esxi_password $vmpath \"stop hard\" 2>&1", $result_array, $return_value);
		if($return_value != 0) {
			$return_value_backup = $return_value;
			$result_array_backup = $result_array;
			
			unset($result_array);
			$result_we_wanted = exec("$BACKEND get_esxi_vm_state $esxi_ip $esxi_username $esxi_password $vmpath 2>&1", $result_array, $return_value);
			if($return_value != 0) print_error($result_array, $return_value);
			
			if(strcmp(trim($result_we_wanted), 'getstate() = on') == 0) {
				print_error($result_array_backup, $return_value_backup);
			} else {
				return;
			}
		}

		while(1) {
			unset($result_array);
			$result_we_wanted = exec("$BACKEND get_esxi_vm_state $esxi_ip $esxi_username $esxi_password $vmpath 2>&1", $result_array, $return_value);
			if($return_value != 0) print_error($result_array, $return_value);

			if(strcmp(trim($result_we_wanted), 'getstate() = off') == 0) {
				break;
			}

			usleep(100000);
		}
	}
}

function start_vm_and_wait($esxi_ip, $esxi_username, $esxi_password, $vmpath) {
	global $BACKEND;

    // Escape variables since then they will be used in command line
	$esxi_username = escapeshellarg($esxi_username);
	$esxi_password = escapeshellarg($esxi_password);
	
	unset($result_array);
	$result_we_wanted = exec("$BACKEND get_esxi_vm_state $esxi_ip $esxi_username $esxi_password $vmpath 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);
	if(strcmp(trim($result_we_wanted), 'getstate() = off') == 0) {
		$result_array = array();
		exec("$BACKEND switch_esxi_vm $esxi_ip $esxi_username $esxi_password $vmpath start 2>&1", $result_array, $return_value);
		if($return_value != 0) print_error($result_array, $return_value);

		while(1) {
			unset($result_array);
			$result_we_wanted = exec("$BACKEND get_esxi_vm_state $esxi_ip $esxi_username $esxi_password $vmpath 2>&1", $result_array, $return_value);
			if($return_value != 0) print_error($result_array, $return_value);

			if(strcmp(trim($result_we_wanted), 'getstate() = on') == 0) {
				break;
			}

			usleep(100000);
		}
	}
}


function print_error($result_array, $return_value) {
	$lines = '';
	foreach($result_array as $line) {
		echo $line . "\n";
		$lines .= $line;
	}
	shm_print_error($lines);
	exit($return_value);
}

function shm_print_error($error_message) {
	global $SHM_ERROR_REPORT_ID;

	if(($shm_key = ftok(__FILE__, 'e')) == -1) {
		return false;
	}
	if(($shm_id = shm_attach($shm_key)) === false) {
		return false;
	}

	if(shm_put_var($shm_id, $SHM_ERROR_REPORT_ID, $error_message) === false) {
		return false;
	}

	return true;
}

function shm_get_error() {
	global $SHM_ERROR_REPORT_ID;

	if(($shm_key = ftok(__FILE__, 'e')) == -1) {
		return false;
	}
	if(($shm_id = shm_attach($shm_key)) === false) {
		return false;
	}

	unset($error_message);
	if(($error_message = shm_get_var($shm_id, $SHM_ERROR_REPORT_ID)) === false) {
		return false;
	}

	/*
	if(shm_remove($shm_id) === false) {
		return false;
	}
	 */

	return $error_message;
}

function dtascfg_get_nat_network_config($sc_id, &$dhcp, &$ip, &$mask, &$gateway, &$dns) {
        global $DTASCFG_XML_FILE;
        if (($obj_xml = simplexml_load_file($DTASCFG_XML_FILE)) == false) {
            return false;
        }

        $element_name = "cluster_" . $sc_id;
        $dhcp    = $obj_xml->$element_name->nat->dhcp;
        $ip      = $obj_xml->$element_name->nat->ip;
        $mask    = $obj_xml->$element_name->nat->netmask;
        $gateway = $obj_xml->$element_name->nat->gateway;
        $dns     = $obj_xml->$element_name->nat->dns;

        return true;
}

function dtascfg_get_controller_network_config($sc_id, &$dhcp, &$ip, &$mask, &$gateway, &$dns) {
        global $DTASCFG_XML_FILE;
        if (($obj_xml = simplexml_load_file($DTASCFG_XML_FILE)) == false) {
            return false;
        }

        $element_name = "cluster_" . $sc_id;
        $dhcp    = $obj_xml->$element_name->sandbox_controller->dhcp_1;
        $ip      = $obj_xml->$element_name->sandbox_controller->ip_1;
        $mask    = $obj_xml->$element_name->sandbox_controller->netmask_1;
        $gateway = $obj_xml->$element_name->sandbox_controller->gateway_1;
        $dns     = $obj_xml->$element_name->sandbox_controller->dns_1;

        return true;
}

function dtascfg_get_cluster_exsi_config($sc_id, &$esxi_ip, &$esxi_username, &$esxi_password, &$sandbox_controller_vmpath) {
    global $DTASCFG_XML_FILE;
    $cfg_xml = simplexml_load_file($DTASCFG_XML_FILE);
    
    if($sc_id == 1) {
        $esxi_ip = $cfg_xml->esxi->ip;
	    $esxi_username = $cfg_xml->esxi->username;
	    $esxi_password = $cfg_xml->esxi->password;
	    $sandbox_controller_vmpath = $cfg_xml->sandbox_controller->image_path;
    }
    else {
        $value = $cfg_xml->xpath("/configuration/cluster_$sc_id/esxi/ip");
        if(array_key_exists(0, $value)) {
            $esxi_ip = $value[0];            
        }
        else {
            echo "Can not find esxi ip by given sandbox controller id\n";
            exit(1);
        }
        
        $value = $cfg_xml->xpath("/configuration/cluster_$sc_id/esxi/username");
        if(array_key_exists(0, $value)) {
            $esxi_username = $value[0];            
        }
        else {
            echo "Can not find esxi user name by given sandbox controller id\n";
            exit(1);
        }
                    
        $value = $cfg_xml->xpath("/configuration/cluster_$sc_id/esxi/password");
        if(array_key_exists(0, $value)) {
            $esxi_password = $value[0];            
        }
        else {
            echo "Can not find esxi password by given sandbox controller id\n";
            exit(1);
        }
        
        $value = $cfg_xml->xpath("/configuration/cluster_$sc_id/sandbox_controller/image_path");
        if(array_key_exists(0, $value)) {
            $sandbox_controller_vmpath = $value[0];            
        }
        else {
            echo "Can not find sandbox controller image path by given sandbox controller id\n";
            exit(1);
        }
    }        
}

function create_revertd_conf($revert_conf_path, $config_xpath = "") {
    global $DTASCFG_XML_FILE;

    $cfg_xml		= simplexml_load_file($DTASCFG_XML_FILE);
    $cluster_xml	= ($config_xpath != "" ? $cfg_xml->$config_xpath : $cfg_xml);

	$esxi_ip		= chop($cluster_xml->esxi->ip);
	$esxi_username	= chop($cluster_xml->esxi->username);
	$esxi_password	= $cluster_xml->esxi->password;

	$revertd_conf = <<<EOF
esxi_ip = $esxi_ip
esxi_username = $esxi_username
esxi_password = $esxi_password
max_worker = 5
debug = 0
EOF;

	$fp = fopen($revert_conf_path, "w");
	if($fp === false) {
		echo 'fopen error';
		exit(1);
	}
	
	$conf_length = strlen($revertd_conf);
	$fwrite_result = fwrite($fp, $revertd_conf);
	if($fwrite_result === false || $fwrite_result != $conf_length) {
		echo 'fwrite error';
		exit(1);
	}
	fclose($fp);
}

function create_liteserver_ini($ini_path, $ip_usage_path ) {
    global $DTASCFG_XML_FILE ;
    
    $cfg_xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
	$dtas_dir = rtrim( chop( $cfg_xml->cli->dtas_dir ), '/' ) ;
   
    $revert_command = "$dtas_dir/SandboxController/bin/revertd/revert" ;
    $image_pathes = '' ;
    
    $lines = file( $ip_usage_path ) ;
    foreach( $lines as $line ) {
        $line = trim( $line ) ;
        $vmpath_and_ip = explode( "=", $line ) ;
        $vmpath = $vmpath_and_ip[ 0 ] ;
        $ip     = $vmpath_and_ip[ 1 ] ;
        $image_pathes .= "$ip=$revert_command $vmpath\n" ;
    }
    
	$liteserver_ini = <<<EOF
[BASIC]

// Maximum time span to handle a sample, 90 seconds
TimeOutForSample = 700

// Once a server is available, time span to receive response
// after sending request
TimeOutForClient = 150

// Server will query state of client every StateIntervalSecond
// StateIntervalSecond = 20

// Once the number of processed malicious sample is above specific value
// VMware will be revert.
SampleCountForRevert = 1
MaliciousSampleCountForRevert = 1

// IP address of Linux server's VMware for connecting clients.
IPAddress = 1.1.1.1
Port=4935
LogPort=4936

//DEBUG:1, INFO:2, WARNING:3, ERROR:4, FATAL:5
LogLevel=2

CompressToolPath = /usr/bin/unzip
//VMToolsPath = vbox

//Purge task folder time interval, in hours.
TaskFolderPurgePeriod = 72

[Update]
Port=4937
UpdatePackage = $dtas_dir/sandcastle/repcon/bin/tools.zip

[Image Path]
// Key is IP address of each virtual machine client and value is
// the image path of it.
$image_pathes
EOF;

	$fp = fopen($ini_path, "w");
	if($fp === false) {
		echo 'fopen error';
		exit(1);
	}
	
	$ini_length = strlen($liteserver_ini);
	$fwrite_result = fwrite($fp, $liteserver_ini);
	if($fwrite_result === false || $fwrite_result != $ini_length) {
		echo 'fwrite error';
		exit(1);
	}
	fclose($fp);
}

function exec_command( $command, $msg_when_error = array(), $exit_when_error = 1 ) {
    # debug_print( join( " ", $command ) ) ;
    # echo( join( " ", $command ) ) . "\n" ;
    
    unset( $result_array ) ;
    exec( join( " ", $command ) . " 2>&1", $result_array, $return_value ) ;
    $msg_array = count( $msg_when_error ) == 0 ? $result_array : $msg_when_error ;

    # debug_print( "return_value: $return_value" ) ;
    # debug_print( "result_array: " . join( "\n", $msg_array ) ) ;
    
    # error occurs
    if( $return_value != 0 ) {
        if( $exit_when_error == 1 ) {
            shm_print_error( join( "\n", $msg_array ) ) ;
            exit( $return_value ) ;
        }
    }
    return array( $return_value, $msg_array ) ;
}

function run_command_at_esxi( $argv ) {
    global $DTASCFG_XML_FILE ;
    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    
    $esxi_ip         = isset( $argv[ 'esxi_ip' ] )       ? $argv[ 'esxi_ip' ]       : trim( $xml -> esxi -> ip ) ;
    $esxi_username   = isset( $argv[ 'esxi_username' ] ) ? $argv[ 'esxi_username' ] : trim( $xml -> esxi -> username ) ;
    $esxi_password   = isset( $argv[ 'esxi_password' ] ) ? $argv[ 'esxi_password' ] : $xml -> esxi -> password;
    $msg_when_error  = isset( $argv[ 'msg_when_error' ] )  ? $argv[ 'msg_when_error' ]  : array() ;
    $exit_when_error = isset( $argv[ 'exit_when_error' ] ) ? $argv[ 'exit_when_error' ] : 1 ;
    $command         = $argv[ 'command' ] ;

    
    ############################################################
    # execute
    ############################################################
    $ssh_cmd = 'sh ' . dirname(__FILE__) . '/ssh_cmd.sh' ;
    $ret_array = exec_command(
        array(
            $ssh_cmd,
            escapeshellarg( $esxi_ip ) ,
            escapeshellarg( $esxi_username ) ,
            escapeshellarg( $esxi_password ) ,
            escapeshellarg( $command ) ),
        $msg_when_error,
        $exit_when_error ) ;

    # followings only be executed when variable $exit_when_error = 0
    
    # first two lines are garbage information, ignore them.
    array_shift( $ret_array[ 1 ] ) ;
    array_shift( $ret_array[ 1 ] ) ;
    
    return $ret_array ;
}

function run_program_at_esxi( $argv ) {
    global $DTASCFG_XML_FILE ;
    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    
    $esxi_ip       = isset( $argv[ 'esxi_ip' ] )       ? $argv[ 'esxi_ip' ]       : trim( $xml -> esxi -> ip ) ;
    $esxi_username = isset( $argv[ 'esxi_username' ] ) ? $argv[ 'esxi_username' ] : trim( $xml -> esxi -> username ) ;
    $esxi_password = isset( $argv[ 'esxi_password' ] ) ? $argv[ 'esxi_password' ] : $xml -> esxi -> password;

    $msg_when_error  = isset( $argv[ 'msg_when_error' ] )  ? $argv[ 'msg_when_error' ]  : array() ;
    $exit_when_error = isset( $argv[ 'exit_when_error' ] ) ? $argv[ 'exit_when_error' ] : 1 ;
    $output_path     = isset( $argv[ 'pipe_to' ] )         ? $argv[ 'pipe_to' ]         : null ;
    $is_escape       = isset( $argv[ 'escape' ] )          ? $argv[ 'escape' ]          : 1 ;

    $program   = $argv[ 'program' ] ;
    $arguments = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;

    
    ############################################################
    # escape arguments
    ############################################################
    $result_args = "" ;
    if( $is_escape == 1 ) {
        for( $i = 0 ; $i < count( $arguments ); $i++ ) {
            $result_args .= escapeshellarg( $arguments[ $i ] ) . " " ;
        }
        $result_args = trim( $result_args ) ;
    }
    
    else {
        $result_args = join( " ", $arguments ) ;
    }


    ############################################################
    # redirect output to another file
    ############################################################

    # a magic, don' know why...
    if( $output_path !== null ) {
        $result_args .= " \"\\\"> $output_path\\\"\"" ;
    }
    

    ############################################################
    # execute
    ############################################################
    $ssh_cmd = 'sh ' . dirname(__FILE__) . '/ssh_cmd.sh' ;
    $ret_array = exec_command(
        array(
            $ssh_cmd,
            escapeshellarg( $esxi_ip ) ,
            escapeshellarg( $esxi_username ) ,
            escapeshellarg( $esxi_password ) ,
            escapeshellarg( $program ),
            $result_args ),
        $msg_when_error,
        $exit_when_error ) ;

    # followings only be executed when variable $exit_when_error = 0
    
    # first two lines are garbage information, ignore them.
    array_shift( $ret_array[ 1 ] ) ;
    array_shift( $ret_array[ 1 ] ) ;
    
    return $ret_array ;
}

function run_program_at_esxi_by_ssh( $argv ) {
    global $DTASCFG_XML_FILE ;
    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    
    $esxi_ip       = isset( $argv[ 'esxi_ip' ] )       ? $argv[ 'esxi_ip' ]       : trim( $xml -> esxi -> ip ) ;
    $esxi_username = isset( $argv[ 'esxi_username' ] ) ? $argv[ 'esxi_username' ] : trim( $xml -> esxi -> username ) ;
    $esxi_password = isset( $argv[ 'esxi_password' ] ) ? $argv[ 'esxi_password' ] : trim( $xml -> esxi -> password ) ;
    $isBlocking    = isset( $argv[ 'esxi_block' ] )    ? $argv[ 'esxi_block' ]    : true ;
    $esxi_port = getEsxiShellPort($esxi_ip);
    
    $program   = $argv[ 'program' ] ;
    $arguments = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
    
    
    ############################################################
    # execute
    ############################################################
    if( is_host_sshable( $esxi_ip ) == false ) {
        $msg = "SshToEsxiFail: esxi_ip='$esxi_ip', esxi_username='$esxi_username'" ;
        debug_print( $msg ) ;
        return array( "1", array( $msg ) ) ;
    }

    $connection = ssh2_connect( $esxi_ip, $esxi_port ) ;
    if( ssh2_auth_password( $connection, $esxi_username, $esxi_password ) === false ) {
        $msg = "LoginToEsxiFail: esxi_ip='$esxi_ip', esxi_username='$esxi_username'" ;
        debug_print( $msg ) ;
        return array( "1", array( $msg ) ) ;
    }

    $command = join( " ", array( $program,
                                 count( $arguments ) == 0 ? "" : join( " ", $arguments ),
                                 "; echo \$?" ) ) ;
                        
    debug_print( "command='$command'" ) ;
        $stdoutStream = ssh2_exec( $connection, $command ) ;
    $stderrStream = ssh2_fetch_stream( $stdoutStream, SSH2_STREAM_STDERR ) ;

    if( $stdoutStream === false ) {
        $msg = "ExecuteCommandFail: command='$command'" ;
        debug_print( $msg ) ;
        return array( "1", array( $msg ) ) ;
    }

    $retValue = "0" ;
    $outMsgArray = array() ;
    $errMsgArray = array() ;
    if( $isBlocking === true ) {
        debug_print( "WaitingForSshResult..." ) ;
        stream_set_blocking( $stdoutStream, 1 ) ;
        debug_print( "ReceivedSshResult..." ) ;
        
        $outMsgArray = preg_split( "/\n+/", trim( stream_get_contents( $stdoutStream ) ) ) ;
        $errMsgArray = preg_split( "/\n+/", trim( stream_get_contents( $stderrStream ) ) ) ;
        $retValue = array_pop( $outMsgArray ) ;
    }
    
    fclose( $stdoutStream ) ;
    fclose( $stderrStream ) ;

    return array( $retValue,
                  $outMsgArray,
                  $errMsgArray ) ;
}

function run_program_at_ms( $argv ) {
    $msg_when_error  = isset( $argv[ 'msg_when_error' ] )  ? $argv[ 'msg_when_error' ]  : array() ;
    $exit_when_error = isset( $argv[ 'exit_when_error' ] ) ? $argv[ 'exit_when_error' ] : 1 ;
    $output_path     = isset( $argv[ 'pipe_to' ] )         ? $argv[ 'pipe_to' ]         : null ;
    $is_escape       = isset( $argv[ 'escape' ] )          ? $argv[ 'escape' ]          : 1 ;
    
    $program   = $argv[ 'program' ] ;
    $arguments = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
    
    
    ############################################################
    # escape arguments
    ############################################################
    $result_args = "" ;
    if( $is_escape == 1 ) {
        for( $i = 0 ; $i < count( $arguments ); $i++ ) {
            $result_args .= escapeshellarg( $arguments[ $i ] ) . " " ;
        }
        $result_args = trim( $result_args ) ;
    }
    
    else {
        $result_args = join( " ", $arguments ) ;
    }

    
    ############################################################
    # redirect output to another file
    ############################################################

    # a magic, don' know why...
    if( $output_path !== null ) {
        $result_args .= " > '$output_path'" ;
    }
    

    ############################################################
    # execute
    ############################################################
    $ret_array = exec_command(
        array(
            $program,
            $result_args ),
        $msg_when_error,
        $exit_when_error ) ;
        
    # this statement only be executed when variable $exit_when_error = 0
    return $ret_array ;
}

function run_program_at_ms_by_ssh( $argv ) {
    global $DTASCFG_XML_FILE ;
    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    
    $ms_ip       = isset( $argv[ 'ms_ip' ] )       ? $argv[ 'ms_ip' ]       : trim( $xml -> management_server -> ip ) ;
    $ms_username = isset( $argv[ 'ms_username' ] ) ? $argv[ 'ms_username' ] : trim( $xml -> management_server -> admin_username ) ;
    $ms_password = isset( $argv[ 'ms_password' ] ) ? $argv[ 'ms_password' ] : trim( $xml -> management_server -> admin_password ) ;
    $isBlocking  = isset( $argv[ 'is_block' ] )    ? $argv[ 'is_block' ]    : true ;
    
    $program   = $argv[ 'program' ] ;
    $arguments = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
    
    
    ############################################################
    # escape arguments
    ############################################################
    for( $i = 0 ; $i < count( $arguments ); $i++ ) {
        $arguments[ $i ] = escapeshellarg( $arguments[ $i ] ) ;
    }

    
    ############################################################
    # execute
    ############################################################
    $connection = ssh2_connect( $ms_ip ) ;
    if( ssh2_auth_password( $connection, $ms_username, $ms_password ) === false ) {
        $msg = "LoginToSandBoxControllerFail: ms_ip='$ms_ip'" ;
        debug_print( $msg ) ;
        return array( "1", array( $msg ) ) ;
    }

    $command = join( " ",
                 array( $program,
                        join( " ", $arguments ),
                        "; echo \$?" ) ) ;
    debug_print( "command='$command'" ) ;
    $stdoutStream = ssh2_exec( $connection, $command ) ;
    $stderrStream = ssh2_fetch_stream( $stdoutStream, SSH2_STREAM_STDERR ) ;

    if( $stdoutStream === false ) {
        $msg = "ExecuteCommandFail: command='$command'" ;
        debug_print( $msg ) ;
        return array( "1", array( $msg ) ) ;
    }

    $retValue = "0" ;
    $outMsgArray = array() ;
    $errMsgArray = array() ;
    if( $isBlocking === true ) {
        debug_print( "WaitingForSshResult..." ) ;
        stream_set_blocking( $stdoutStream, 1 ) ;
        
        $outMsgArray = preg_split( "/\n+/", trim( stream_get_contents( $stdoutStream ) ) ) ;
        $errMsgArray = preg_split( "/\n+/", trim( stream_get_contents( $stderrStream ) ) ) ;
        debug_print( "ReceivedSshResult..." ) ;
        
        $retValue = array_pop( $outMsgArray ) ;
    }
    
    fclose( $stdoutStream ) ;
    fclose( $stderrStream ) ;

    return array( $retValue,
                  $outMsgArray,
                  $errMsgArray ) ;
}

function run_program_at_sc( $argv ) {
    global $DTASCFG_XML_FILE, $BACKEND ;
    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    
    $esxi_ip         = isset( $argv[ 'esxi_ip' ] )         ? $argv[ 'esxi_ip' ]         : trim( $xml -> esxi -> ip ) ;
    $esxi_username   = isset( $argv[ 'esxi_username' ] )   ? $argv[ 'esxi_username' ]   : trim( $xml -> esxi -> username ) ;
    $esxi_password   = isset( $argv[ 'esxi_password' ] )   ? $argv[ 'esxi_password' ]   : $xml -> esxi -> password;
    $sc_username     = isset( $argv[ 'sc_username' ] )     ? $argv[ 'sc_username' ]     : trim( $xml -> sandbox_controller -> admin_username ) ;
    $sc_password     = isset( $argv[ 'sc_password' ] )     ? $argv[ 'sc_password' ]     : $xml -> sandbox_controller -> admin_password;
    $sc_vmpath_vix   = isset( $argv[ 'sc_vmpath_vix' ] )   ? $argv[ 'sc_vmpath_vix' ]   : trim( $xml -> sandbox_controller -> image_path_vix ) ;
    $output_path     = isset( $argv[ 'pipe_to' ] )         ? $argv[ 'pipe_to' ]         : null ;
    $msg_when_error  = isset( $argv[ 'msg_when_error' ] )  ? $argv[ 'msg_when_error' ]  : array() ;
    $exit_when_error = isset( $argv[ 'exit_when_error' ] ) ? $argv[ 'exit_when_error' ] : 1 ;
    $is_escape       = isset( $argv[ 'escape' ] )          ? $argv[ 'escape' ]          : 1 ;
    
    $program   = $argv[ 'program' ] ;
    $arguments = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
    
    if( $sc_vmpath_vix == "" ) {
        $sc_prefix = isset( $argv[ 'sc_prefix' ] ) ? $argv[ 'sc_prefix' ] : trim( $xml -> sandbox_controller -> prefix ) ;
        $sc_vmpath_vix = get_vm_vixpath(
            $esxi_ip,
            $esxi_username,
            $esxi_password,
            $sc_prefix ) ;
    }

    ############################################################
    # escape arguments
    ############################################################
    $result_args = "" ;
    if( $is_escape == 1 ) {
        for( $i = 0 ; $i < count( $arguments ); $i++ ) {
            $result_args .= escapeshellarg( $arguments[ $i ] ) . " " ;
        }
        $result_args = trim( $result_args ) ;
    }
    
    else {
        $result_args = join( " ", $arguments ) ;
    }
    // print( "result_args = $result_args" . "\n" ) ;
    
    
    ############################################################
    # redirect output to another file
    ############################################################

    # a magic, don' know why...
    if( $output_path !== null ) {
        $result_args .= " \"\\\"> $output_path\\\"\"" ;
    }
    
    ############################################################
    # execute
    ############################################################
    # vmrun -T server -h $esxi_host -u $esxi_username -p $esxi_password -gu $vm_username -gp $vm_password runProgramInGuest $vm_path $command $arguments
    # $cmd = "$BACKEND run_program_in_vm_by_vix" ;
    $cmd = "vmrun" ;
    $ret_array = exec_command(
        array(
            $cmd,
            "-T",  "server",
            "-h",  escapeshellarg( $esxi_ip ),
            "-u",  escapeshellarg( $esxi_username ),
            "-p",  escapeshellarg( $esxi_password ),
            "-gu", escapeshellarg( $sc_username ),
            "-gp", escapeshellarg( $sc_password ),
            "runProgramInGuest",
            escapeshellarg( $sc_vmpath_vix ),
            escapeshellarg( $program ),
            $result_args ),
        $msg_when_error,
        $exit_when_error ) ;
        
    # this statement only be executed when variable $exit_when_error = 0
    return $ret_array ;
}

function run_program_at_sc_by_ssh( $argv, $confidential_option_list = array() ) {
    global $DTASCFG_XML_FILE ;
    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    
    $sc_ip       = isset( $argv[ 'sc_ip' ] )       ? $argv[ 'sc_ip' ]       : trim( $xml -> sandbox_controller -> ip ) ;
    $sc_username = isset( $argv[ 'sc_username' ] ) ? $argv[ 'sc_username' ] : trim( $xml -> sandbox_controller -> admin_username ) ;
    $sc_password = isset( $argv[ 'sc_password' ] ) ? $argv[ 'sc_password' ] : trim( $xml -> sandbox_controller -> admin_password ) ;
    $isBlocking  = isset( $argv[ 'is_block' ] )    ? $argv[ 'is_block' ]    : true ;
    
    $program   = $argv[ 'program' ] ;
    $arguments = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
    
    
    ############################################################
    # escape arguments
    ############################################################
    for( $i = 0 ; $i < count( $arguments ); $i++ ) {
        $arguments[ $i ] = escapeshellarg( $arguments[ $i ] ) ;
    }

    
    ############################################################
    # execute
    ############################################################
    $connection = ssh2_connect( $sc_ip ) ;
    if( ssh2_auth_password( $connection, $sc_username, $sc_password ) === false ) {
        $msg = "LoginToSandBoxControllerFail: sc_ip='$sc_ip'" ;
        debug_print( $msg ) ;
        return array( "1", array( $msg ) ) ;
    }

    $command = join( " ",
                 array( $program,
                        join( " ", $arguments ),
                        "; echo \$?" ) ) ;
    $mask_command = CommonUtility::mask_confidential_option_list($command, $confidential_option_list);
    debug_print( "command='$mask_command'" ) ;
    $stdoutStream = ssh2_exec( $connection, $command ) ;
    $stderrStream = ssh2_fetch_stream( $stdoutStream, SSH2_STREAM_STDERR ) ;

    if( $stdoutStream === false ) {
        $msg = "ExecuteCommandFail: command='$command'" ;
        debug_print( $msg ) ;
        return array( "1", array( $msg ) ) ;
    }

    $retValue = "0" ;
    $outMsgArray = array() ;
    $errMsgArray = array() ;
    if( $isBlocking === true ) {
        debug_print( "WaitingForSshResult..." ) ;
        stream_set_blocking( $stdoutStream, 1 ) ;
        
        $outMsgArray = preg_split( "/\n+/", trim( stream_get_contents( $stdoutStream ) ) ) ;
        $errMsgArray = preg_split( "/\n+/", trim( stream_get_contents( $stderrStream ) ) ) ;
        debug_print( "ReceivedSshResult..." ) ;
        
        $retValue = array_pop( $outMsgArray ) ;
    }
    
    fclose( $stdoutStream ) ;
    fclose( $stderrStream ) ;

    return array( $retValue,
                  $outMsgArray,
                  $errMsgArray ) ;
}

function copy_file_to_esxi( $argv ) {
    global $DTASCFG_XML_FILE, $BACKEND ;
    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    
    $esxi_ip       = isset( $argv[ 'esxi_ip' ] )       ? $argv[ 'esxi_ip' ]       : trim( $xml -> esxi -> ip ) ;
    $esxi_username = isset( $argv[ 'esxi_username' ] ) ? $argv[ 'esxi_username' ] : trim( $xml -> esxi -> username ) ;
    $esxi_password = isset( $argv[ 'esxi_password' ] ) ? $argv[ 'esxi_password' ] : $xml -> esxi -> password;
    $fp_source     = $argv[ 'from' ] ;
    $fp_target     = $argv[ 'to' ] ;

    $cmd = "$BACKEND scp_put_to_esxi_server" ;
    exec_command( array(
        $cmd,
        escapeshellarg( $esxi_ip ) ,
        escapeshellarg( $esxi_username ) ,
        escapeshellarg( $esxi_password ) ,
        escapeshellarg( $fp_source ) ,
        escapeshellarg( $fp_target ) ) ) ;
}

function copy_file_to_sc( $argv ) {
    global $DTASCFG_XML_FILE ;
    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    
    $esxi_ip         = isset( $argv[ 'esxi_ip' ] )         ? $argv[ 'esxi_ip' ]         : trim( $xml -> esxi -> ip ) ;
    $esxi_username   = isset( $argv[ 'esxi_username' ] )   ? $argv[ 'esxi_username' ]   : trim( $xml -> esxi -> username ) ;
    $esxi_password   = isset( $argv[ 'esxi_password' ] )   ? $argv[ 'esxi_password' ]   :       $xml -> esxi -> password;
    $sc_username     = isset( $argv[ 'sc_username' ] )     ? $argv[ 'sc_username' ]     : trim( $xml -> sandbox_controller -> admin_username ) ;
    $sc_password     = isset( $argv[ 'sc_password' ] )     ? $argv[ 'sc_password' ]     :       $xml -> sandbox_controller -> admin_password;
    $sc_vmpath_vix   = isset( $argv[ 'sc_vmpath_vix' ] )   ? $argv[ 'sc_vmpath_vix' ]   : trim( $xml -> sandbox_controller -> image_path_vix ) ;
    $msg_when_error  = isset( $argv[ 'msg_when_error' ] )  ? $argv[ 'msg_when_error' ]  : array() ;
    $exit_when_error = isset( $argv[ 'exit_when_error' ] ) ? $argv[ 'exit_when_error' ] : 1 ;

    $from = $argv[ 'from' ] ;
    $to   = $argv[ 'to' ] ;
    
    if( $sc_vmpath_vix == "" ) {
        $sc_prefix = isset( $argv[ 'sc_prefix' ] ) ? $argv[ 'sc_prefix' ] : trim( $xml -> sandbox_controller -> prefix ) ;
        $sc_vmpath_vix = get_vm_vixpath(
            $esxi_ip,
            $esxi_username,
            $esxi_password,
            $sc_prefix ) ;
    }

    $cmd = "vmrun" ;
    $ret_array = exec_command(
        array( $cmd,
               "-T",  "server",
               "-h",  escapeshellarg( $esxi_ip ),
               "-u",  escapeshellarg( $esxi_username ),
               "-p",  escapeshellarg( $esxi_password ),
               "-gu", escapeshellarg( $sc_username ),
               "-gp", escapeshellarg( $sc_password ),
               "CopyFileFromHostToGuest",
               escapeshellarg( $sc_vmpath_vix ),
               escapeshellarg( $from ),
               escapeshellarg( $to ) ),
        $msg_when_error,
        $exit_when_error ) ;
        
    # this statement only be executed when variable $exit_when_error = 0
    return $ret_array ;
}

function copy_file_from_sc( $argv ) {
    global $DTASCFG_XML_FILE ;
    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    
    $esxi_ip         = isset( $argv[ 'esxi_ip' ] )         ? $argv[ 'esxi_ip' ]         : trim( $xml -> esxi -> ip ) ;
    $esxi_username   = isset( $argv[ 'esxi_username' ] )   ? $argv[ 'esxi_username' ]   : trim( $xml -> esxi -> username ) ;
    $esxi_password   = isset( $argv[ 'esxi_password' ] )   ? $argv[ 'esxi_password' ]   :       $xml -> esxi -> password ;
    $sc_username     = isset( $argv[ 'sc_username' ] )     ? $argv[ 'sc_username' ]     : trim( $xml -> sandbox_controller -> admin_username ) ;
    $sc_password     = isset( $argv[ 'sc_password' ] )     ? $argv[ 'sc_password' ]     :       $xml -> sandbox_controller -> admin_password ;
    $sc_vmpath_vix   = isset( $argv[ 'sc_vmpath_vix' ] )   ? $argv[ 'sc_vmpath_vix' ]   : trim( $xml -> sandbox_controller -> image_path_vix ) ;
    $msg_when_error  = isset( $argv[ 'msg_when_error' ] )  ? $argv[ 'msg_when_error' ]  : array() ;
    $exit_when_error = isset( $argv[ 'exit_when_error' ] ) ? $argv[ 'exit_when_error' ] : 1 ;

    $fp_source     = $argv[ 'from' ] ;
    $fp_target     = $argv[ 'to' ] ;
    
    if( $sc_vmpath_vix == "" ) {
        $sc_prefix = isset( $argv[ 'sc_prefix' ] ) ? $argv[ 'sc_prefix' ] : trim( $xml -> sandbox_controller -> prefix ) ;
        $sc_vmpath_vix = get_vm_vixpath(
            $esxi_ip,
            $esxi_username,
            $esxi_password,
            $sc_prefix ) ;
    }
    
    $cmd = "vmrun" ;
    $ret_array = exec_command(
        array( $cmd,
               "-T",  "server",
               "-h",  escapeshellarg( $esxi_ip ),
               "-u",  escapeshellarg( $esxi_username ),
               "-p",  escapeshellarg( $esxi_password ),
               "-gu", escapeshellarg( $sc_username ),
               "-gp", escapeshellarg( $sc_password ),
               "CopyFileFromGuestToHost",
               escapeshellarg( $sc_vmpath_vix ),
               escapeshellarg( $fp_source ),
               escapeshellarg( $fp_target ) ),
        $msg_when_error,
        $exit_when_error ) ;
        
    # this statement only be executed when variable $exit_when_error = 0
    return $ret_array ;
}

function copy_file_from_sc_by_ssh( $argv ) {
    global $DTASCFG_XML_FILE ;
    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    
    $sc_ip       = isset( $argv[ 'sc_ip' ] )       ? $argv[ 'sc_ip' ]       : trim( $xml -> sandbox_controller -> ip ) ;
    $sc_username = isset( $argv[ 'sc_username' ] ) ? $argv[ 'sc_username' ] : trim( $xml -> sandbox_controller -> admin_username ) ;
    $sc_password = isset( $argv[ 'sc_password' ] ) ? $argv[ 'sc_password' ] : trim( $xml -> sandbox_controller -> admin_password ) ;
    
    $from = $argv[ 'from' ] ;
    $to   = $argv[ 'to' ] ;

    # execute
    $connection = ssh2_connect( $sc_ip ) ;
    if( ssh2_auth_password( $connection, $sc_username, $sc_password ) === false ) {
        $msg = "LoginToSandBoxControllerFail: sc_ip='$sc_ip', sc_username='$sc_username'" ;
        debug_print( $msg ) ;
        return array( "1", array( $msg ) ) ;
    }

    $stepName = "CopyFileFromScBySsh" ;
    $result = ssh2_scp_recv( $connection,
                             $from,
                             $to ) ;
    
    if( $result == false ) {
        $msg = "${stepName}Fail: sc_ip='$sc_ip', sc_username='$sc_username', from='$from', to='$to'" ;
        debug_print( $msg ) ;
        return array( "1", array( $msg ) ) ;
    }
    
    $msg = "${stepName}Pass: sc_ip='$sc_ip', sc_username='$sc_username', from='$from', to='$to'" ;
    debug_print( $msg ) ;
    return array( "0", array( $msg ) ) ;
}

function copy_file_from_ms( $argv ) { # usually used for copy file from cluster's ms

    global $DTASCFG_XML_FILE, $BACKEND ;
    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    
    $esxi_ip       = isset( $argv[ 'esxi_ip' ] )       ? $argv[ 'esxi_ip' ]       : trim( $xml -> esxi -> ip ) ;
    $esxi_username = isset( $argv[ 'esxi_username' ] ) ? $argv[ 'esxi_username' ] : trim( $xml -> esxi -> username ) ;
    $esxi_password = isset( $argv[ 'esxi_password' ] ) ? $argv[ 'esxi_password' ] : $xml -> esxi -> password;
    $ms_username   = isset( $argv[ 'ms_username' ] )   ? $argv[ 'ms_username' ]   : trim( $xml -> management_server -> admin_username ) ;
    $ms_password   = isset( $argv[ 'ms_password' ] )   ? $argv[ 'ms_password' ]   : $xml -> management_server -> admin_password;
    $ms_vmpath     = isset( $argv[ 'ms_vmpath' ] )     ? $argv[ 'ms_vmpath' ]     : trim( $xml -> management_server -> image_path ) ;
    $ms_prefix     = isset( $argv[ 'ms_prefix' ] )     ? $argv[ 'ms_prefix' ]     : trim( $xml -> management_server -> prefix ) ;
    $fp_source     = $argv[ 'from' ] ;
    $fp_target     = $argv[ 'to' ] ;
    
    $ms_vmpath_vix = get_vm_vixpath(
        $esxi_ip,
        $esxi_username,
        $esxi_password,
        $ms_prefix ) ;
        
    $copy_cmd = "$BACKEND copy_file_from_vm_to_server_by_vix" ;
    exec_command( array(
        $copy_cmd,
        escapeshellarg( $esxi_ip ) ,
        escapeshellarg( $esxi_username ) ,
        escapeshellarg( $esxi_password ) ,
        escapeshellarg( $ms_username ) ,
        escapeshellarg( $ms_password ) ,
        escapeshellarg( $ms_vmpath_vix ) ,
        escapeshellarg( $fp_source ) ,
        escapeshellarg( $fp_target ) ) ) ;
}

function is_host_sshable( $ip ) {
    $conn = ssh2_connect( $ip ) ;
    if( ! $conn ) {
        return false ;
    }
    return true ;
}

function stepRunProgramAtMs( $argv ) {
    $stepName = "RunProgramAtMs" ;
    
    # composing debug message
    $msg = $stepName . ": " . escapeshellarg( $argv[ 'program' ] ) ;
    $arguments_array = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
    foreach( $arguments_array as $argument ) {
        $msg .=  " " . escapeshellarg( $argument ) ;
    }
    debug_print( $msg ) ;
    
    # launching
    $ret_array = run_program_at_ms( $argv ) ;
    
    # verify return code
    $retCode = $ret_array[ 0 ] ;
    $msg     = join( "\n", $ret_array[ 1 ] ) ;
    if( $retCode != 0 ) {
        $errMsg = "${stepName}Fail: ret='$retCode', msg='$msg'" ;
        debug_print( $errMsg ) ;
        throw new Exception( $errMsg ) ;
    }
    debug_print( "${stepName}Pass: msg='$msg'" ) ;
    
    return $ret_array ;
}

function stepRunProgramAtMsBySsh( $argv ) {
    $stepName = "RunProgramAtMsBySsh" ;
    
    # composing debug message
    $msg = $stepName . ": " . escapeshellarg( $argv[ 'program' ] ) ;
    $arguments_array = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
    foreach( $arguments_array as $argument ) {
        $msg .=  " " . escapeshellarg( $argument ) ;
    }
    debug_print( $msg ) ;
    
    # launching
    $ret_array = run_program_at_ms_by_ssh( $argv ) ;
    
    # verify return code
    $retCode      = $ret_array[ 0 ] ;
    $stdoutMsgAry = $ret_array[ 1 ] ;
    $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
    if( $retCode != 0 ) {
        $stderrMsgAry = $ret_array[ 2 ] ;
        $stderrMsg    = join( "\n", $stderrMsgAry ) ;
        throw new Exception( "${stepName}Fail: ret=$retCode, msg='$stderrMsg'" ) ;
    }
    debug_print( "${stepName}Pass: msg='$stdoutMsg'" ) ;
    
    return $ret_array ;
}

function stepRunProgramAtSc( $argv ) {
    $stepName = "RunProgramAtSc" ;
    
    # composing debug message
    $msg = $stepName . ": " . escapeshellarg( $argv[ 'program' ] ) ;
    $arguments_array = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
    foreach( $arguments_array as $argument ) {
        $msg .=  " " . escapeshellarg( $argument ) ;
    }
    debug_print( $msg ) ;
    
    # launching
    $ret_array = run_program_at_sc( $argv ) ;
    
    # verify return code
    $retCode = $ret_array[ 0 ] ;
    $msg     = join( "\n", $ret_array[ 1 ] ) ;
    if( $retCode != 0 ) {
        $errMsg = "${stepName}Fail: ret='$retCode', msg='$msg'" ;
        debug_print( $errMsg ) ;
        throw new Exception( $errMsg ) ;
    }
    debug_print( "${stepName}Pass: msg='$msg'" ) ;
    
    return $ret_array ;
}

function stepRunProgramAtScBySsh( $argv ) {
    $stepName = "RunProgramAtMsBySsh" ;
    
    # composing debug message
    $msg = $stepName . ": " . escapeshellarg( $argv[ 'program' ] ) ;
    $arguments_array = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
    foreach( $arguments_array as $argument ) {
        $msg .=  " " . escapeshellarg( $argument ) ;
    }
    debug_print( $msg ) ;
    
    # launching
    $ret_array = run_program_at_sc_by_ssh( $argv ) ;
    
    # verify return code
    $retCode      = $ret_array[ 0 ] ;
    $stdoutMsgAry = $ret_array[ 1 ] ;
    $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
    if( $retCode != 0 ) {
        $stderrMsgAry = $ret_array[ 2 ] ;
        $stderrMsg    = join( "\n", $stderrMsgAry ) ;
        throw new Exception( "${stepName}Fail: ret=$retCode, msg='$stderrMsg'" ) ;
    }
    debug_print( "${stepName}Pass: msg='$stdoutMsg'" ) ;
    
    return $ret_array ;
}

function stepCopyFileToSc( $argv ) {
    $stepName = "CopyFileToSc" ;
    
    # composing debug message
    $msg = $stepName . ": remote=" . escapeshellarg( $argv[ 'from' ] ) . ", local=" . escapeshellarg( $argv[ 'to' ] ) ;
    debug_print( $msg ) ;
    
    # launching
    $ret_array = copy_file_to_sc( $argv ) ;
    
    # verify return code
    $retCode = $ret_array[ 0 ] ;
    $msg     = join( "\n", $ret_array[ 1 ] ) ;
    if( $retCode != 0 ) {
        $errMsg = "${stepName}Fail: ret='$retCode', msg='$msg'" ;
        debug_print( $errMsg ) ;
        throw new Exception( $errMsg ) ;
    }
    debug_print( "${stepName}Pass: msg='$msg'" ) ;
}

function stepCopyFileFromSc( $argv ) {
    $stepName = "CopyFileFromSc" ;
    
    # composing debug message
    $msg = $stepName . ": remote=" . escapeshellarg( $argv[ 'from' ] ) . ", local=" . escapeshellarg( $argv[ 'to' ] ) ;
    debug_print( $msg ) ;
    
    # launching
    $ret_array = copy_file_from_sc( $argv ) ;
    
    # verify return code
    $retCode = $ret_array[ 0 ] ;
    $msg     = join( "\n", $ret_array[ 1 ] ) ;
    if( $retCode != 0 ) {
        $errMsg = "${stepName}Fail: ret='$retCode', msg='$msg'" ;
        debug_print( $errMsg ) ;
        throw new Exception( $errMsg ) ;
    }
    debug_print( "${stepName}Pass: msg='$msg'" ) ;
}

function startsWith($haystack, $needle)
{
   return !strncmp($haystack, $needle, strlen($needle));
}

function endsWith($haystack, $needle)
{
   $length = strlen($needle);
   if ($length == 0) {
       return true;
   }

   return (substr($haystack, -$length) === $needle);
}

function isInternalIP($ip) {
    //the ' symbol is for ip with escape character
    return startsWith($ip, "169.254.3.") || startsWith($ip, "'169.254.3.");
}

function getEsxiShellPort($ip) {
    if(isInternalIP($ip)) return 22;
    return 1022;
}

function getEsxiPort($ip) {
    if(isInternalIP($ip)) return 443;
    return 10443;
}
